


%% Sample Date Info
% sampledates_vec = {...
% 	[2016,04,26,14,00,00],[2016,04,26,15,30,00];...
% 	[2016,04,28,09,45,00],[2016,04,28,14,50,00];...
% 	[2016,04,28,18,30,00],[2016,04,29,04,30,00];...
% 	[2016,05,01,11,30,00],[2016,05,01,15,30,00];...
% 	[2016,05,02,09,00,00],[2016,05,02,17,15,00];...
% 	[2016,05,02,20,00,00],[2016,05,03,06,00,00];...
% 	[2016,05,05,08,00,00],[2016,05,05,21,00,00];...
% 	[2016,05,06,12,00,00],[2016,05,06,16,45,00];...
% 	[2016,05,07,11,00,00],[2016,05,07,15,40,00];...
% 	[2016,05,10,12,00,00],[2016,05,10,16,45,00];...
% 	[2016,05,14,11,00,00],[2016,05,14,15,45,00]};

%only SP analyzed days
sampledates_vec = {...
	[2016,04,26,14,00,00],[2016,04,26,15,30,00];...
	[2016,04,28,09,45,00],[2016,04,28,14,50,00];...
	[2016,04,28,18,30,00],[2016,04,29,04,30,00];...
	[2016,05,01,11,30,00],[2016,05,01,15,30,00];...
	[2016,05,02,20,00,00],[2016,05,03,06,00,00];...
	[2016,05,05,08,00,00],[2016,05,05,21,00,00];...
	[2016,05,14,11,00,00],[2016,05,14,15,45,00]};


sampledates = cellfun(@datetime,sampledates_vec);

%% CPC Data
[conctime, conc] = CPC_Import();

for j = 1:size(sampledates_vec,1)
	currsampletime = logical((conctime >= sampledates(j,1)) .* (conctime <= sampledates(j,2)));
	avgconc(j,1) = nanmean(conc(currsampletime));
	
end
% conctime = currsampletime;

%% ACSM Data
clear time;
hiscale_importACSM();

for j = 1:size(sampledates_vec,1)
	currsampletime = logical((time >= sampledates(j,1)) .* (time <= sampledates(j,2)));
	
	avgorg(j,1) = nanmean(org(currsampletime));
	avgam(j,1) = nanmean(am(currsampletime));
	avgsul(j,1) = nanmean(sul(currsampletime));
	avgnit(j,1) = nanmean(nit(currsampletime));
	avgchl(j,1) = nanmean(chl(currsampletime));
	
end

%% CO data
[cotime,co,n2o] = hiscale_importCO();

for j = 1:size(sampledates_vec,1)
	currsampletime = logical((cotime >= sampledates(j,1)) .* (cotime <= sampledates(j,2)));
	
	avgco(j,1) = nanmean(co(currsampletime));
	avgn2o(j,1) = nanmean(n2o(currsampletime));
	
end
% cotime = currsampletime;


